<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Slider_model extends CI_Model
{

    public function insert_slider($data)
    {

        return $this->db->insert('slider', $data);
    }


    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('slider')->result();
    }



    // public function delete_slider($id)
    // {
    //     $this->db->where('id', $id);
    //     $this->db->delete('slider');
    //     return $this->db->affected_rows();
    // }

    public function delete_slider($id)
    {
        // Step 1: Fetch file path from DB
        $this->db->select('slider_image');
        $this->db->from('slider');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete image file if it exists
        if (!empty($row) && !empty($row->slider_image)) {
            $image_path = FCPATH . $row->slider_image;
            if (file_exists($image_path)) {
                unlink($image_path); // Delete the file from folder
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('slider');

        // Step 4: Optional - return status
        if ($this->db->affected_rows() > 0) {
            return true; // Deleted successfully
        } else {
            return false; // Something went wrong
        }
    }

    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('slider');
        $this->db->where('id', $id);
        $blog = $this->db->get()->row();

        if ($blog) {
            // Toggle status
            $new_status = ($blog->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('slider', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // blog not found
    }

    public function get_slider_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('slider')->row();
    }

    public function update_slider($id, $data)
    {
        return $this->db->where('id', $id)->update('slider', $data);
    }

    public function get_all_slider()
    {
        $this->db->where('status', 'active');
        $this->db->order_by('id', 'desc');
        return $this->db->get('slider')->result();
    }
}