<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Video_gallery_model extends CI_Model
{

    public function add_video_gallery($data)
    {

        return $this->db->insert('video_gallery', $data);
    }


    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('video_gallery')->result();
    }



    public function delete_video($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('video_gallery');
        return $this->db->affected_rows();
    }

    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('video_gallery');
        $this->db->where('id', $id);
        $blog = $this->db->get()->row();

        if ($blog) {
            // Toggle status
            $new_status = ($blog->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('video_gallery', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // blog not found
    }
}