<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Event | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Event </h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Event</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="eventForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Title</label>
                                        <input type="text" class="form-control" id="validationCustom01" name="title"
                                            required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Title.</div>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Title</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_title" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Title.</div>
                                        <span id="error-hindi_title" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom05" class="form-label">Slug</label>
                                        <input type="text" class="form-control" id="validationCustom05" name="slug"
                                            required>
                                        <span class="small">
                                            Only <strong>letters (a-z)</strong>, <strong>numbers (0-9)</strong>, and
                                            <strong>hyphens (-)</strong> are allowed in the slug.<br>
                                            Special symbols such as <code>@</code>, <code>#</code>, <code>$</code>,
                                            <code>%</code>, <code>&</code>, <code>*</code>, <code>_</code>,
                                            <code>/</code>, <code>?</code>, <code>!</code>, etc. are <strong>not
                                                allowed</strong>.
                                        </span>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Slug.</div>
                                        <span id="error-slug" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom05" class="form-label">Hindi Slug</label>
                                        <input type="text" class="form-control" id="validationCustom05"
                                            name="hindi_slug" required>
                                        <span class="small">
                                            Only <strong>letters (a-z)</strong>, <strong>numbers (0-9)</strong>, and
                                            <strong>hyphens (-)</strong> are allowed in the slug.<br>
                                            Special symbols such as <code>@</code>, <code>#</code>, <code>$</code>,
                                            <code>%</code>, <code>&</code>, <code>*</code>, <code>_</code>,
                                            <code>/</code>, <code>?</code>, <code>!</code>, etc. are <strong>not
                                                allowed</strong>.
                                        </span>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Slug.</div>
                                        <span id="error-hindi_slug" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label for="validationCustom03" class="form-label">Content</label>
                                        <div id="snow-editor" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content">
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Content.</div>
                                        <span id="error-content" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom06" class="form-label">Hindi Content</label>
                                        <div id="snow-editor-hindi" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content">
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Content.</div>
                                        <span id="error-hindi_content" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label for="featured_image" class="form-label">Image</label>
                                        <div class="filepond-uploader">
                                            <input type="file" id="featured_image" name="featured_image"
                                                class="filepond filepond-input-multiple form-control"
                                                data-allow-reorder="true" data-max-file-size="3MB" data-max-files="1"
                                                aria-label="file example" required>
                                        </div>

                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid image.</div>
                                        <span id="error-featured_image" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            // ✅ Initialize Quill editors
            const quillEnglish = new Quill('#snow-editor', { theme: 'snow' });
            const quillHindi = new Quill('#snow-editor-hindi', { theme: 'snow' });

            // ✅ Initialize FilePond
            const pond = FilePond.create(document.querySelector('#featured_image'));

            $("#eventForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                // ✅ Get content
                const englishContent = quillEnglish.root.innerHTML.trim();
                const hindiContent = quillHindi.root.innerHTML.trim();

                // ✅ Store in hidden fields
                $("#hidden-content").val(englishContent);
                $("#hidden-hindi-content").val(hindiContent);

                // ✅ Build FormData
                const formData = new FormData(this);

                // ✅ Add FilePond file
                if (pond.getFiles().length > 0) {
                    formData.append('featured_image', pond.getFiles()[0].file);
                } else {
                    $("#error-featured_image").html('Please select an image');
                    return;
                }

                $.ajax({
                    url: "<?= base_url('admin/event/submit_event') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log("AJAX Error:", xhr.responseText);
                    }
                });
            });
        });
    </script>






</body>

</html>