<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Blog | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Blog</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Blog</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="blogForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <input type="hidden" name="id" value="<?= $blog->id ?>">

                                    <!-- Title Fields -->
                                    <div class="col-md-6">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title" value="<?= $blog->title ?>"
                                            required>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title</label>
                                        <input type="text" class="form-control" name="hindi_title"
                                            value="<?= $blog->hindi_title ?>" required>
                                        <span id="error-hindi_title" class="text-danger error"></span>
                                    </div>

                                    <!-- Slug Fields -->
                                    <div class="col-md-6">
                                        <label class="form-label">Slug</label>
                                        <input type="text" class="form-control" name="slug" value="<?= $blog->slug ?>"
                                            required>
                                        <span id="error-slug" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Slug</label>
                                        <input type="text" class="form-control" name="hindi_slug"
                                            value="<?= $blog->hindi_slug ?>" required>
                                        <span id="error-hindi_slug" class="text-danger error"></span>
                                    </div>

                                    <!-- Category Fields -->
                                    <div class="col-md-6">
                                        <label class="form-label">Category</label>
                                        <select name="category" class="form-select" required>
                                            <option value="<?= $blog->category ?>"><?= $blog->category ?></option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->category ?>"><?= $data->category ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <span id="error-category" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Category</label>
                                        <select name="hindi_category" class="form-select" required>
                                            <option value="<?= $blog->hindi_category ?>"><?= $blog->hindi_category ?>
                                            </option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->hindi_category ?>"><?= $data->hindi_category ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <span id="error-hindi_category" class="text-danger error"></span>
                                    </div>

                                    <!-- Author Fields -->
                                    <div class="col-md-6">
                                        <label class="form-label">Author</label>
                                        <input type="text" class="form-control" name="author"
                                            value="<?= $blog->author ?>" required>
                                        <span id="error-author" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Author</label>
                                        <input type="text" class="form-control" name="hindi_author"
                                            value="<?= $blog->hindi_author ?>" required>
                                        <span id="error-hindi_author" class="text-danger error"></span>
                                    </div>

                                    <!-- Quill Editors -->
                                    <div class="col-md-12">
                                        <label class="form-label">Content</label>
                                        <div id="snow-editor" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content">
                                        <span id="error-content" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-12">
                                        <label class="form-label">Hindi Content</label>
                                        <div id="snow-editor-hindi" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content">
                                        <span id="error-hindi_content" class="text-danger error"></span>
                                    </div>

                                    <!-- File Upload -->
                                    <div class="col-md-12">
                                        <label for="featured_image" class="form-label">Image</label>
                                        <input type="file" id="featured_image" name="featured_image" class="filepond" />
                                        <span id="error-featured_image" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {
            // ✅ Initialize both Quill editors
            const quillEnglish = new Quill('#snow-editor');
            const quillHindi = new Quill('#snow-editor-hindi', { theme: 'snow' });

            // ✅ Pre-fill existing content
            quillEnglish.root.innerHTML = `<?= addslashes($blog->content) ?>`;
            quillHindi.root.innerHTML = `<?= addslashes($blog->hindi_content) ?>`;

            // ✅ Initialize FilePond
            let featuredImage = '<?= $blog->featured_image ?>';
            if (featuredImage && !featuredImage.startsWith('http')) {
                featuredImage = '<?= base_url() ?>' + featuredImage;
            }
            featuredImage = featuredImage.replace(/([^:]\/)\/+/g, "$1");

            const pond = FilePond.create(document.querySelector('#featured_image'), {
                allowMultiple: false,
                maxFiles: 1,
                files: featuredImage ? [{
                    source: featuredImage,
                    options: { type: 'local' }
                }] : []
            });

            // ✅ Handle form submission
            $("#blogForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                // Get Quill content
                const englishContent = quillEnglish.root.innerHTML.trim();
                const hindiContent = quillHindi.root.innerHTML.trim();

                $("#hidden-content").val(englishContent);
                $("#hidden-hindi-content").val(hindiContent);

                const formData = new FormData(this);

                // ✅ Add FilePond file
                if (pond.getFiles().length > 0) {
                    formData.append('featured_image', pond.getFiles()[0].file);
                }

                // ✅ Send AJAX
                $.ajax({
                    url: "<?= base_url('admin/blog/update_blog') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error("AJAX Error:", xhr.responseText);
                    }
                });
            });
        });
    </script>





</body>

</html>