<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Course Category | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Course Category</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-6">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Course Category</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="courseForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <input type="hidden" name="id" value="<?= $category->id ?>">
                                    <div class="col-md-12">
                                        <label for="validationCustom01" class="form-label">Category</label>
                                        <input type="text" class="form-control" id="validationCustom01" name="category"
                                            value="<?= $category->category ?>" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom02" class="form-label">Hindi Category</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_category" value="<?= $category->hindi_category ?>" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-hindi_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            $("#courseForm").on("submit", function (e) {
                e.preventDefault(); // prevent page reload
                $(".error").html(""); // clear old errors

                // Create FormData object
                var formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/courses/update_course_category') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
        });
    </script>

</body>

</html>