<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Team | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Team</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Team</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate id="teamForm" method="POST"
                                    enctype="multipart/form-data">
                                    <input type="hidden" name="id" value="<?= $team->id ?>">
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Name
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="validationCustom01" name="name"
                                            value="<?= $team->name ?>" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Name.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Hindi Name
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="validationCustom01"
                                            value="<?= $team->hindi_name ?>" name="hindi_name" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Name.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Image
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <div class="avatar-xxl">
                                            <input type="file" class="filepond filepond-input-circle"
                                                id="validationCustom02" name="featured_image"
                                                accept="image/png, image/jpeg, image/gif"
                                                value="<?= $team->featured_image ?>">
                                        </div>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Image.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email</label>
                                        <input type="text" class="form-control" name="email"
                                            value="<?= $team->email ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">Phone Number
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <input type="tel" class="form-control" id="validationCustom03" name="phone"
                                            pattern="[0-9]{10}" maxlength="10" value="<?= $team->phone ?>" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Phone number.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom04" class="form-label">Designation
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="validationCustom04"
                                            name="designation" value="<?= $team->designation ?>" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Designation.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom04" class="form-label">Hindi Designation
                                            <span class="text-danger-emphasis">*</span>
                                        </label>
                                        <input type="text" class="form-control" id="validationCustom04"
                                            value="<?= $team->hindi_designation ?>" name="hindi_designation" required>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Designation.</div>
                                    </div>

                                    <div class="col-md-12">
                                        <label for="validationCustom03" class="form-label">Content</label>
                                        <div id="snow-editor" style="height: 300px;"></div>
                                        <input type="hidden" name="content" id="hidden-content">
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Content.</div>
                                        <span id="error-content" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom06" class="form-label">Hindi Content</label>
                                        <div id="snow-editor-hindi" style="height: 300px;"></div>
                                        <input type="hidden" name="hindi_content" id="hidden-hindi-content">
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Content.</div>
                                        <span id="error-hindi_content" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const quillEnglish = new Quill('#snow-editor', { theme: 'snow' });
            const quillHindi = new Quill('#snow-editor-hindi', { theme: 'snow' });

            // ✅ Pre-fill existing content
            quillEnglish.root.innerHTML = `<?= addslashes($team->content) ?>`;
            quillHindi.root.innerHTML = `<?= addslashes($team->hindi_content) ?>`;
            // Initialize FilePond
            const inputElement = document.querySelector('.filepond-input-circle');
            const pond = FilePond.create(inputElement, {
                allowMultiple: false,
                maxFiles: 1,
                maxFileSize: '3MB',
                server: null, // No instant upload
                instantUpload: false,
            });

            // ✅ Preload existing image (if editing existing team)
            <?php if (!empty($team->featured_image)): ?>
                pond.addFile("<?= base_url($team->featured_image) ?>").catch(e => console.log(e));
            <?php endif; ?>

            // ✅ Handle form submission
            $("#teamForm").on("submit", function (e) {
                e.preventDefault();

                // Clear previous errors
                $(".invalid-feedback").hide();

                // Get Quill content
                const englishContent = quillEnglish.root.innerHTML.trim();
                const hindiContent = quillHindi.root.innerHTML.trim();

                $("#hidden-content").val(englishContent);
                $("#hidden-hindi-content").val(hindiContent);


                var formData = new FormData(this);

                // Append FilePond files (important)
                pond.getFiles().forEach((fileItem) => {
                    formData.append('featured_image', fileItem.file, fileItem.file.name);
                });

                $.ajax({
                    url: "<?= base_url('admin/teams/update_team') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            // Show field-specific validation errors
                            $.each(response.errors, function (key, val) {
                                let errorElement = $("[name='" + key + "']").closest('.col-md-6, .col-12').find('.invalid-feedback');
                                errorElement.text(val).show();
                            });
                        } else if (response.status === "success") {
                            // Redirect on success
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error("Error:", xhr.responseText);
                    }
                });
            });
        });
    </script>


</body>

</html>