<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Student Application | Hope Harbor Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Student Application</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> Student Application DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>S. No</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; ?>
                                        <?php foreach ($student as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td>
                                                    <a href="#" class="showDetails" data-name="<?= $data->full_name ?>"
                                                        data-dob="<?= date("d-m-Y", strtotime($data->dob)) ?>"
                                                        data-email="<?= $data->email ?>" data-mobile="<?= $data->mobile ?>"
                                                        data-parentname="<?= $data->parent_name ?>"
                                                        data-parentmobile="<?= $data->parent_mobile ?>"
                                                        data-gender="<?= $data->gender ?>"
                                                        data-govtidtype="<?= $data->govt_id_type ?>"
                                                        data-govtidnumber="<?= $data->govt_id_number ?>"
                                                        data-addr1="<?= $data->addr1 ?>" data-addr2="<?= $data->addr2 ?>"
                                                        data-city="<?= $data->city ?>" data-stateut="<?= $data->state_ut ?>"
                                                        data-pin="<?= $data->pin ?>" data-demoicile="<?= $data->domicile ?>"
                                                        data-board="<?= $data->board ?>" data-stream="<?= $data->stream ?>"
                                                        data-schoolname="<?= $data->school_name ?>"
                                                        data-schoolcity="<?= $data->school_city ?>"
                                                        data-passingyear="<?= $data->passing_year ?>"
                                                        data-resultstatus="<?= $data->result_status ?>"
                                                        data-precentage="<?= $data->percentage ?>"
                                                        data-keysubject="<?= $data->key_subjects ?>"
                                                        data-gapyear="<?= $data->gap_year ?>"
                                                        data-gapexplain="<?= $data->gap_explain ?>">
                                                        <?= $data->full_name ?>
                                                    </a>
                                                </td>
                                                <td><?= $data->email ?></td>
                                                <td><?= $data->mobile ?></td>
                                                <td><?= date("d-m-Y", strtotime($data->created_at)) ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <div class="modal fade" id="applicationModal" tabindex="-1">
                <div class="modal-dialog modal-lg modal-dialog-centered">
                    <div class="modal-content">

                        <div class="modal-header">
                            <h5 class="modal-title">Staff Details</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>

                        <div class="modal-body">

                            <!-- TOP CARD -->
                            <div class="p-3 mb-3 d-flex align-items-center"
                                style="background:#f8f9fa;border-radius:10px;">

                                <img id="m_img" src="<?= base_url('assets/admin/images/users/user-3.jpg') ?>" width="80"
                                    height="80" style="border-radius:10px;object-fit:cover;margin-right:15px;">

                                <div style="flex:1;">

                                    <h4 class="mb-0" id="m_name"></h4>
                                </div>

                                <span class="badge bg-success" id="m_status"></span>
                            </div>

                            <!-- TABS -->
                            <ul class="nav nav-tabs mb-3">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#tabBasic">Basic Info</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#tabAddress">Address Info</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#tabEduction">Education Info</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#tabPreference">Program
                                        Preference</a>
                                </li>
                            </ul>

                            <!-- TAB CONTENT -->
                            <div class="tab-content">

                                <div class="tab-pane fade show active" id="tabBasic">
                                    <div class="row mb-2">
                                        <div class="col-md-6 mt-2"><strong>Date of Birth:</strong> <span
                                                id="m_dob"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>Gender:</strong> <span id="m_gender"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>Phone Number:</strong> <span
                                                id="m_mobile"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>Email:</strong> <span id="m_email"></span>
                                        </div>

                                        <div class="col-md-6 mt-2">
                                            <strong>Parent/Guardian Name:</strong> <span id="m_parentname"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Parent/Guardian Mobile:</strong> <span id="m_parentmobile"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Government ID Type:</strong> <span id="m_govtidtype"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Government ID Number:</strong> <span id="m_govtidnumber"></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="tabAddress">
                                    <div class="row mb-2">
                                        <div class="col-md-12 mt-2"><strong>Address Line 1:</strong> <span
                                                id="m_addr1"></span>
                                        </div>
                                        <div class="col-md-12 mt-2"><strong>Address Line 2:</strong> <span
                                                id="m_addr2"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>City:</strong> <span id="m_city"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>State / UT:</strong> <span
                                                id="m_stateut"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Domicile State:</strong> <span id="m_demoicile"></span>
                                        </div>

                                        <div class="col-md-6 mt-2">
                                            <strong>PIN Code:</strong> <span id="m_pin"></span>
                                        </div>


                                    </div>
                                </div>
                                <div class="tab-pane fade" id="tabEduction">
                                    <div class="row mb-2">
                                        <h4>Class 12 Education</h4>
                                        <div class="col-md-6 mt-2"><strong>Board:</strong> <span id="m_board"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>Stream:</strong> <span id="m_stream"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>School Name:</strong> <span
                                                id="m_schoolname"></span>
                                        </div>
                                        <div class="col-md-6 mt-2"><strong>School City:</strong> <span
                                                id="m_schoolcity"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Year of Passing:</strong> <span id="m_passingyear"></span>
                                        </div>

                                        <div class="col-md-6 mt-2">
                                            <strong>Result Status:</strong> <span id="m_resultstatus"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Percentage / Grade:</strong> <span id="m_precentage"></span>
                                        </div>
                                        <div class="col-md-6 mt-2">
                                            <strong>Key Subjects:</strong> <span id="m_keysubject"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="tabPreference">
                                    <div class="row mb-2">
                                        <h4>Program Preference</h4>
                                        <div class="col-md-6 mt-2"><strong>Preference:</strong> <span
                                                id="m_preference"></span>
                                        </div>

                                    </div>
                                </div>

                            </div>

                        </div>

                    </div>
                </div>
            </div>


            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).on("click", ".showDetails", function () {

            $("#m_name").text($(this).data("name"));
            $("#m_dob").text($(this).data("dob"));
            $("#m_email").text($(this).data("email"));
            $("#m_mobile").text($(this).data("mobile"));
            $("#m_parentname").text($(this).data("parentname"));
            $("#m_parentmobile").text($(this).data("parentmobile"));
            $("#m_gender").text($(this).data("gender"));
            $("#m_govtidtype").text($(this).data("govtidtype"));
            $("#m_govtidnumber").text($(this).data("govtidnumber"));
            $("#m_addr1").text($(this).data("addr1"));
            $("#m_addr2").text($(this).data("addr2"));
            $("#m_city").text($(this).data("city"));
            $("#m_stateut").text($(this).data("stateut"));
            $("#m_pin").text($(this).data("pin"));
            $("#m_demoicile").text($(this).data("demoicile"));
            $("#m_board").text($(this).data("board"));
            $("#m_stream").text($(this).data("stream"));
            $("#m_schoolname").text($(this).data("schoolname"));
            $("#m_schoolcity").text($(this).data("schoolcity"));
            $("#m_passingyear").text($(this).data("passingyear"));
            $("#m_resultstatus").text($(this).data("resultstatus"));
            $("#m_precentage").text($(this).data("precentage"));
            $("#m_keysubject").text($(this).data("keysubject"));
            $("#m_gapyear").text($(this).data("gapyear"));
            $("#m_gapexplain").text($(this).data("gapexplain"));
            $("#m_preference").text($(this).data("preference"));


            $("#applicationModal").modal("show");
        });

    </script>
</body>

</html>