<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Blog Deatils | Hope Harbor</title>

    <?php include_once('common_page/links.php') ?>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <?php include_once('common_page/header.php') ?>


        <!-- page-title -->
        <section class="page-title centred">
            <div class="bg-layer"
                style="background-image: url(<?= base_url('') ?>assets/images/background/page-title-4.jpg);"></div>
            <div class="pattern-layer"
                style="background-image: url(<?= base_url('') ?>assets/images/shape/shape-56.png);"></div>
            <div class="auto-container">
                <div class="content-box">
                    <h1>Blog Details</h1>
                    <ul class="bread-crumb clearfix">
                        <li><a href="<?= base_url('') ?>">Home</a></li>
                        <li>Blog Details</li>
                    </ul>
                </div>
            </div>
        </section>
        <!-- page-title end -->


        <!-- sidebar-page-container -->
        <section class="sidebar-page-container bg-color-3 pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                        <div class="blog-standard-content blog-details-content">
                            <div class="news-block-two">
                                <div class="inner-box">
                                    <div class="image-box">
                                        <figure class="image">
                                            <img src="<?= base_url($details->featured_image) ?>" alt="">
                                        </figure>
                                        <div class="post-date">
                                            <i class="icon-32"></i>
                                            <span> <?= date("M d, Y", strtotime($details->date)) ?></span>
                                        </div>
                                    </div>
                                    <div class="lower-content">
                                        <ul class="post-info">
                                            <li><span><?= $language == 'hi' ? $details->hindi_category : $deatils->category ?></span>
                                            </li>
                                            <li>By <span><?= $language == 'hi' ? $details->hindi_author : $deatils->author ?>
                                            </li>
                                        </ul>
                                        <h2><span><?= $language == 'hi' ? $details->hindi_title : $deatils->title ?>
                                        </h2>
                                        <span><?= $language == 'hi' ? $details->hindi_content : $deatils->content ?>
                                    </div>
                                </div>
                            </div>
                            <div class="related-post pb_30">
                                <h2>Related Post</h2>
                                <div class="row clearfix">
                                    <?php if (!empty($related)): ?>
                                        <?php foreach ($related as $data): ?>
                                            <div class="col-lg-6 col-md-6 col-sm-12 news-block">
                                                <div class="news-block-two">
                                                    <div class="inner-box">
                                                        <div class="image-box">
                                                            <figure class="image">
                                                                <a href="<?= base_url('blog-details/' . $data->slug) ?>">
                                                                    <img src="<?= base_url($data->featured_image) ?>" alt="">
                                                                </a>
                                                            </figure>
                                                            <div class="post-date">
                                                                <i class="icon-32"></i>
                                                                <span><?= date("M d, Y", strtotime($data->date)) ?></span>
                                                            </div>
                                                        </div>
                                                        <div class="lower-content">
                                                            <ul class="post-info">
                                                                <li><span><?= $data->category ?></span></li>
                                                                <li>By <?= $data->author ?></li>
                                                            </ul>

                                                            <h3>
                                                                <a href="<?= base_url('blog-details/' . $data->slug) ?>">
                                                                    <?= $data->title ?>
                                                                </a>
                                                            </h3>

                                                            <div class="link-btn">
                                                                <a href="<?= base_url('blog-details/' . $data->slug) ?>">
                                                                    <span>Read More</span><i class="icon-2"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div>
                                            <span>
                                                Related Blog Not Available
                                            </span>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 col-sm-12 sidebar-column">
                        <div class="default-sidebar blog-sidebar">
                            <div class="category-widget sidebar-widget mb_30">
                                <div class="widget-title mb_25">
                                    <h3>Categories</h3>
                                </div>
                                <div class="widget-content">
                                    <ul class="category-list clearfix">
                                        <?php foreach ($category as $data): ?>
                                            <li>
                                                <a href="<?= base_url('blog?category=' . $data->category) ?>">
                                                    <?= $language == 'hi' ? $data->hindi_category : $data->category ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="post-widget sidebar-widget mb_30">
                                <div class="widget-title mb_20">
                                    <h3>Latest Post</h3>
                                </div>
                                <div class="post-inner">
                                    <?php if (!empty($blog)): ?>
                                        <?php
                                        $counter = 0;
                                        foreach ($blog as $data):
                                            if ($counter >= 3)
                                                break;
                                            ?>
                                            <div class="post">
                                                <figure class="thumb-box">
                                                    <a href="<?= base_url('blog-details') ?>">
                                                        <img src="<?= base_url($data->featured_image) ?>" alt="">
                                                    </a>
                                                </figure>
                                                <div class="inner">
                                                    <h5>
                                                        <a href="<?= base_url('blog-details') ?>">
                                                            <?= $language == 'hi' ? $data->hindi_title : $data->title ?>
                                                        </a>
                                                    </h5>
                                                    <div class="post-date">
                                                        <i class="icon-32"></i><?= date("M d, Y", strtotime($data->date)) ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php
                                            $counter++;
                                        endforeach;
                                        ?>
                                    <?php else: ?>
                                        <div>
                                            <span>Blog Not Available</span>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- sidebar-page-container end -->


        <?php include_once('common_page/footer.php') ?>

    </div>


    <?php include_once('common_page/script.php') ?>

</body><!-- End of .page_wrapper -->

</html>