<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Blog | Hope Harbor</title>

    <?php include_once('common_page/links.php') ?>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <?php include_once('common_page/header.php') ?>

        <!-- page-title -->
        <section class="page-title centred">
            <div class="bg-layer"
                style="background-image: url(<?= base_url() ?>assets/images/background/page-title-4.jpg);"></div>
            <div class="pattern-layer"
                style="background-image: url(<?= base_url() ?>assets/images/shape/shape-56.png);"></div>
            <div class="auto-container">
                <div class="content-box">
                    <h1>Blog</h1>
                    <ul class="bread-crumb clearfix">
                        <li><a href="<?= base_url() ?>">Home</a></li>
                        <li>Blog</li>
                    </ul>
                </div>
            </div>
        </section>
        <!-- page-title end -->

        <!-- sidebar-page-container -->
        <section class="sidebar-page-container bg-color-3 pt_120 pb_120">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-8 col-md-12 col-sm-12 content-side">
                        <div class="blog-grid-content">
                            <div class="row clearfix">
                                <?php if (!empty($blog)): ?>
                                    <?php foreach ($blog as $data): ?>
                                        <div class="col-lg-6 col-md-6 col-sm-12 news-block">
                                            <div class="news-block-two">
                                                <div class="inner-box">
                                                    <div class="image-box">
                                                        <figure class="image"><a
                                                                href="<?= base_url('blog-details/' . $data->slug) ?>"><img
                                                                    src="<?= base_url($data->featured_image) ?>" alt=""></a>
                                                        </figure>
                                                        <div class="post-date"><i class="icon-32"></i><span>
                                                                <?= date("M d, Y", strtotime($data->date)) ?>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="lower-content">
                                                        <ul class="post-info">
                                                            <li><span><?= $language == 'hi' ? $data->hindi_category : $data->category ?></span>
                                                            </li>
                                                            <li>By
                                                                <?= $language == 'hi' ? $data->hindi_author : $data->author ?>
                                                            </li>
                                                        </ul>
                                                        <h3>
                                                            <a href="<?= base_url('blog-details/' . $data->slug) ?>">
                                                                <?= $language == 'hi' ? $data->hindi_title : $data->title ?>
                                                            </a>
                                                        </h3>
                                                        <div class="link-btn">
                                                            <a href="<?= base_url('blog-details/' . $data->slug) ?>">
                                                                <span>
                                                                    <?= $language == 'hi' ? 'और पढ़े' : 'Read More' ?>
                                                                </span>
                                                                <i class="icon-2"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div>
                                        <span>Blog Not Available</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="pagination-wrapper pt_30">
                                <ul class="pagination">

                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 col-sm-12 sidebar-column">
                        <div class="default-sidebar blog-sidebar">
                            <div class="category-widget sidebar-widget mb_30">
                                <div class="widget-title mb_25">
                                    <h3>Categories</h3>
                                </div>
                                <div class="widget-content">
                                    <ul class="category-list clearfix">
                                        <?php foreach ($category as $data): ?>
                                            <li>
                                                <a href="<?= base_url('blog?category=' . $data->category) ?>">
                                                    <?= $language == 'hi' ? $data->hindi_category : $data->category ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="post-widget sidebar-widget mb_30">
                                <div class="widget-title mb_20">
                                    <h3>Latest Post</h3>
                                </div>
                                <div class="post-inner">
                                    <?php if (!empty($blog)): ?>
                                        <?php
                                        $counter = 0;
                                        foreach ($blog as $data):
                                            if ($counter >= 3)
                                                break;
                                            ?>
                                            <div class="post">
                                                <figure class="thumb-box">
                                                    <a href="<?= base_url('blog-details') ?>">
                                                        <img src="<?= base_url($data->featured_image) ?>" alt="">
                                                    </a>
                                                </figure>
                                                <div class="inner">
                                                    <h5>
                                                        <a href="<?= base_url('blog-details') ?>">
                                                            <?= $language == 'hi' ? $data->hindi_title : $data->title ?>
                                                        </a>
                                                    </h5>
                                                    <div class="post-date">
                                                        <i class="icon-32"></i><?= date("M d, Y", strtotime($data->date)) ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <?php
                                            $counter++;
                                        endforeach;
                                        ?>
                                    <?php else: ?>
                                        <div>
                                            <span>Blog Not Available</span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- sidebar-page-container end -->

        <?php include_once('common_page/footer.php') ?>

    </div>


    <?php include_once('common_page/script.php') ?>

    <script>
        document.addEventListener("DOMContentLoaded", function () {

            const items = document.querySelectorAll(".news-block"); // All blog cards
            const perPage = 10;  // Show only 10
            const paginationContainer = document.querySelector(".pagination");

            let currentPage = 1;
            const totalPages = Math.ceil(items.length / perPage);

            function showPage(page) {
                currentPage = page;

                let start = (page - 1) * perPage;
                let end = start + perPage;

                items.forEach((item, index) => {
                    item.style.display = (index >= start && index < end) ? "block" : "none";
                });

                updatePagination();
            }

            function updatePagination() {
                paginationContainer.innerHTML = "";

                // Previous Button
                let prev = document.createElement("li");
                prev.innerHTML = `<a href="javascript:void(0)"><i class="icon-39"></i></a>`;
                prev.onclick = () => {
                    if (currentPage > 1) showPage(currentPage - 1);
                };
                paginationContainer.appendChild(prev);

                // Page Numbers
                for (let i = 1; i <= totalPages; i++) {
                    let li = document.createElement("li");
                    li.innerHTML = `<a href="javascript:void(0)" class="${i === currentPage ? 'current' : ''}">${i}</a>`;
                    li.onclick = () => showPage(i);
                    paginationContainer.appendChild(li);
                }

                // Next Button
                let next = document.createElement("li");
                next.innerHTML = `<a href="javascript:void(0)"><i class="icon-40"></i></a>`;
                next.onclick = () => {
                    if (currentPage < totalPages) showPage(currentPage + 1);
                };
                paginationContainer.appendChild(next);
            }

            showPage(1);
        });
    </script>


</body><!-- End of .page_wrapper -->

</html>