<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Contact Us | Hope Harbor</title>

    <!-- Fav Icon -->
    <?php include_once('common_page/links.php'); ?>

</head>


<!-- page wrapper -->

<body>

    <div class="boxed_wrapper ltr">

        <?php include_once('common_page/header.php'); ?>

        <!-- page-title -->
        <section class="page-title centred">
            <div class="bg-layer"
                style="background-image: url(<?= base_url() ?>assets/images/background/page-title-3.jpg);"></div>
            <div class="pattern-layer"
                style="background-image: url(<?= base_url() ?>assets/images/shape/shape-56.png);"></div>
            <div class="auto-container">
                <div class="content-box">
                    <h1>Contact Us</h1>
                    <ul class="bread-crumb clearfix">
                        <li><a href="<?= base_url() ?>">Home</a></li>
                        <li>Contact Us</li>
                    </ul>
                </div>
            </div>
        </section>
        <!-- page-title end -->


        <!-- contact-section -->
        <section class="contact-section bg-color-3 pt_120 pb_120">
            <div class="auto-container">
                <div class="upper-content mb_120">
                    <div class="row clearfix">
                        <div class="col-lg-6 col-md-12 col-sm-12 content-column">
                            <div class="content-box">
                                <div class="sec-title mb_35">
                                    <span class="sub-title mb_12">Get in Touch</span>
                                    <h2>Lets Connect with Us</h2>
                                    <p class="mt_15">More than of the public reviews by our users mention amazing and
                                        super fast customer support as one of our Lorem ipsum dolor sit amet,
                                        consectetur and adipiscing elit. Donec felis, suscipit you takeer action against
                                        fraud.</p>
                                </div>
                                <div class="inner-box">
                                    <div class="single-item">
                                        <div class="icon-box"><i class="icon-43"></i></div>
                                        <div class="inner">
                                            <h4>Call Us</h4>
                                            <p><a href="tel:9632587410">+91 9632587410</a></p>
                                        </div>
                                    </div>
                                    <div class="single-item">
                                        <div class="icon-box"><i class="icon-18"></i></div>
                                        <div class="inner">
                                            <h4>Email Us</h4>
                                            <p><a href="mailto:info@example.com">info@example.com</a></p>
                                        </div>
                                    </div>
                                    <div class="single-item">
                                        <div class="icon-box"><i class="icon-17"></i></div>
                                        <div class="inner">
                                            <h4>Head Office</h4>
                                            <p>Madhya Pradesh, India</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 col-sm-12 form-column">
                            <div class="form-inner">
                                <form method="post" id="contactForm" class="default-form">
                                    <div class="row clearfix">
                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <label>Full Name*</label>
                                            <input type="text" name="name" placeholder="" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <label>Email Address</label>
                                            <input type="email" name="email" placeholder="" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <label>Phone No</label>
                                            <input type="tel" name="phone" maxlength="10" pattern="[0-9]{10}"
                                                oninput="this.value=this.value.slice(0,10);" required>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                                            <label>Subject</label>
                                            <input type="text" name="subject" placeholder="" required>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                            <label>Message</label>
                                            <textarea name="message" placeholder="Message"></textarea>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn">
                                            <button type="submit" class="theme-btn btn-one"><span
                                                    class="text">Submit</span></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Toast Notification Container -->
                <div id="toast" style="
                                    visibility: hidden;
                                    min-width: 250px;
                                    background: #333;
                                    color: #fff;
                                    text-align: left;
                                    border-radius: 8px;
                                    padding: 16px;
                                    position: fixed;
                                    right: -23rem;
                                    bottom: 20px;
                                    z-index: 9999;
                                    transition: all 0.5s ease;
                                ">
                </div>
                <div class="map-inner">
                    <iframe
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3733878.0574792842!2d75.77941154864534!3d23.947519655333178!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39667381d35aea05%3A0xe0106b0d4e701c1e!2sMadhya%20Pradesh!5e0!3m2!1sen!2sin!4v1762953657034!5m2!1sen!2sin"
                        width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
        </section>
        <!-- contact-section end -->


        <?php include_once('common_page/footer.php'); ?>
    </div>


    <?php include_once('common_page/script.php'); ?>

</body><!-- End of .page_wrapper -->

</html>

<script>
    $(document).ready(function () {
        $("#contactForm").on("submit", function (e) {
            e.preventDefault(); // Stop normal form submission

            $(".error").html(""); // Clear errors


            $.ajax({
                url: "<?= base_url('contact/save') ?>",
                type: "POST",
                data: $(this).serialize(),
                dataType: "json",
                success: function (response) {
                    if (response.status === "error") {
                        $.each(response.errors, function (key, value) {
                            $("#error-" + key).html(value);
                        });
                    } else if (response.status === "success") {
                        $("#contactForm")[0].reset();
                        showToast(response.message, "success");
                    }
                },
                error: function () {
                    showToast("Something went wrong. Try again.", "error");
                }
            });
        });

        // Toast function
        function showToast(message, type) {
            var toast = $("#toast");
            toast.html(message);

            if (type === "success") {
                toast.css("background", "#28a745");
            } else {
                toast.css("background", "#dc3545");
            }

            toast.css("visibility", "visible").css("right", "20px");

            setTimeout(function () {
                toast.css("right", "-23rem");
            }, 3000); // hide after 3 seconds
        }
    });
</script>