<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Applicant Registration | Hope Harbor</title>

    <?php include_once('common_page/links.php'); ?>
</head>

<body class="bg-light">
    <?php include_once('common_page/header.php'); ?>
    <!-- page-title -->
    <section class="page-title centred">
        <div class="bg-layer"
            style="background-image: url(<?= base_url() ?>assets/images/background/page-title-2.jpg);"></div>
        <div class="pattern-layer" style="background-image: url(<?= base_url() ?>assets/images/shape/shape-56.png);">
        </div>
        <div class="auto-container">
            <div class="content-box">
                <h1>Student Regsiter</h1>
                <ul class="bread-crumb clearfix">
                    <li><a href="<?= base_url() ?>">Home</a></li>
                    <li>Student Regsiter</li>
                </ul>
            </div>
        </div>
    </section>
    <!-- page-title end -->
    <!-- Yeh form ke bilkul upar laga do -->
    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= $this->session->flashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= $this->session->flashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <div class="container py-4">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="mb-3">Applicant Registration</h4>

                <div class="step-ind" aria-hidden="true">
                    <div class="pill active" data-step="0">1</div>
                    <div class="pill" data-step="1">2</div>
                    <div class="pill" data-step="2">3</div>
                    <div class="pill" data-step="3">4</div>
                    <div class="pill" data-step="4">5</div>
                    <div class="pill" data-step="5">6</div>
                </div>

                <form id="regForm" method="POST" action="<?= base_url('student_form/submit_application') ?>"
                    enctype="multipart/form-data" novalidate>
                    <!-- STEP 1: Applicant Details -->
                    <div class="step active" data-step="0" id="step-0">
                        <h5>1) Applicant Details</h5>

                        <div class="row gy-2 mt-2">
                            <div class="col-md-6">
                                <label class="form-label">Full Name <span class="text-danger">*</span></label>
                                <input name="full_name" class="form-control" type="text" required maxlength="120" />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Date of Birth <span class="text-danger">*</span></label>
                                <input name="dob" class="form-control" type="date" required max="" />
                                <div class="error">Required / Invalid date</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Mobile Number (India, 10 digits)
                                    <span class="text-danger">*</span></label>
                                <input name="mobile" class="form-control" type="text" inputmode="numeric"
                                    pattern="^[6-9]\d{9}$" maxlength="10" placeholder="e.g. 9876543210" required />
                                <div class="error">
                                    Enter valid 10-digit Indian mobile starting with 6-9
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Email <span class="text-danger">*</span></label>
                                <input name="email" class="form-control" type="email" required />
                                <div class="error">Enter valid email</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Parent/Guardian Name <span class="text-danger">*</span>
                                </label>
                                <input name="parent_name" class="form-control" type="text" required />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Parent/Guardian Mobile </label>
                                <input name="parent_mobile" class="form-control" type="text" inputmode="numeric"
                                    pattern="^\d{10}$" maxlength="10" required />
                                <div class="error">Enter valid 10-digit number</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Gender<span class="text-danger">*</span>
                                </label>
                                <select name="gender" class="form-select" required>
                                    <option value="">Prefer not to say</option>
                                    <option>Female</option>
                                    <option>Male</option>
                                    <option>Non-binary</option>
                                    <option>Prefer not to say</option>
                                    <option>Self-describe</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Government ID Type<span class="text-danger">*</span>
                                </label>
                                <select name="govt_id_type" class="form-select" required>
                                    <option value="">None</option>
                                    <option>Aadhaar</option>
                                    <option>Voter ID</option>
                                    <option>Passport</option>
                                    <option>Driving Licence</option>
                                    <option>Other</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Government ID Number<span class="text-danger">*</span>
                                </label>
                                <input name="govt_id_number" class="form-control" type="text" maxlength="30" required />
                                <div class="error">Required</div>
                            </div>
                        </div>
                    </div>

                    <!-- STEP 2: Address -->
                    <div class="step" data-step="1" id="step-1">
                        <h5>2) Address</h5>

                        <div class="row gy-2 mt-2">
                            <div class="col-12">
                                <label class="form-label">Address Line 1 <span class="text-danger">*</span></label>
                                <input name="addr1" class="form-control" type="text" required />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Address Line 2
                                    <span class="small text-muted">(optional)</span></label>
                                <input name="addr2" class="form-control" type="text" />
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">City <span class="text-danger">*</span></label>
                                <input name="city" class="form-control" type="text" required />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">State / UT <span class="text-danger">*</span></label>
                                <select name="state_ut" class="form-select" required>
                                    <option value="">Select State / UT</option>
                                    <option>Andhra Pradesh</option>
                                    <option>Arunachal Pradesh</option>
                                    <option>Assam</option>
                                    <option>Bihar</option>
                                    <option>Chhattisgarh</option>
                                    <option>Goa</option>
                                    <option>Gujarat</option>
                                    <option>Haryana</option>
                                    <option>Himachal Pradesh</option>
                                    <option>Jharkhand</option>
                                    <option>Karnataka</option>
                                    <option>Kerala</option>
                                    <option>Madhya Pradesh</option>
                                    <option>Maharashtra</option>
                                    <option>Manipur</option>
                                    <option>Meghalaya</option>
                                    <option>Mizoram</option>
                                    <option>Nagaland</option>
                                    <option>Odisha</option>
                                    <option>Punjab</option>
                                    <option>Rajasthan</option>
                                    <option>Sikkim</option>
                                    <option>Tamil Nadu</option>
                                    <option>Telangana</option>
                                    <option>Tripura</option>
                                    <option>Uttar Pradesh</option>
                                    <option>Uttarakhand</option>
                                    <option>West Bengal</option>
                                    <option>Delhi</option>
                                    <option>Puducherry</option>
                                    <option>Lakshadweep</option>
                                    <option>Jammu & Kashmir</option>
                                    <option>Ladakh</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">PIN Code <span class="text-danger">*</span></label>
                                <input name="pin" class="form-control" type="text" pattern="^\d{6}$" maxlength="6"
                                    required />
                                <div class="error">Enter valid 6-digit PIN</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Domicile State
                                    <span class="small text-muted">(optional)</span></label>
                                <select name="domicile" class="form-select">
                                    <option value="">Not specified</option>
                                    <option>Andhra Pradesh</option>
                                    <option>Madhya Pradesh</option>
                                    <option>Maharashtra</option>
                                    <option>Uttar Pradesh</option>
                                    <!-- abbreviated, expand if needed -->
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- STEP 3: Class 12 Education -->
                    <div class="step" data-step="2" id="step-2">
                        <h5>3) Class 12 Education</h5>

                        <div class="row gy-2 mt-2">
                            <div class="col-md-6">
                                <label class="form-label">Board <span class="text-danger">*</span></label>
                                <select name="board" class="form-select" required>
                                    <option value="">Select Board</option>
                                    <option>CBSE</option>
                                    <option>ISC</option>
                                    <option>State Board</option>
                                    <option>NIOS</option>
                                    <option>Other</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Stream <span class="text-danger">*</span></label>
                                <select name="stream" class="form-select" required>
                                    <option value="">Select Stream</option>
                                    <option>Science</option>
                                    <option>Commerce</option>
                                    <option>Arts–Humanities</option>
                                    <option>Vocational</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">School Name <span class="text-danger">*</span></label>
                                <input name="school_name" class="form-control" type="text" required />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">School City <span class="text-danger">*</span></label>
                                <input name="school_city" class="form-control" type="text" required />
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Year of Passing (YYYY)
                                    <span class="text-danger">*</span></label>
                                <input name="passing_year" class="form-control" type="number" min="1900" max="2099"
                                    required />
                                <div class="error">Enter 4-digit year</div>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Result Status <span class="text-danger">*</span></label>
                                <select name="result_status" id="result_status" class="form-select" required>
                                    <option value="">Select</option>
                                    <option value="Declared">Declared</option>
                                    <option value="Awaited">Awaited</option>
                                </select>
                                <div class="error">Required</div>
                            </div>

                            <div class="col-md-4" id="percentage_col">
                                <label class="form-label">Percentage / Grade
                                    <span class="text-danger">*</span></label>
                                <input name="percentage" class="form-control" type="text" />
                                <div class="error">Required when result declared</div>
                            </div>

                            <div class="col-6">
                                <label class="form-label">Key Subjects
                                    <span class="text-danger">*</span>
                                </label>

                                <div class="tag-container" id="tagContainer">
                                    <div class="tag-dropdown">
                                        <input type="text" id="tagInput" class="tag-input"
                                            placeholder="Type to search subjects..." autocomplete="off">
                                        <div class="tag-suggestions" id="tagSuggestions"></div>
                                    </div>
                                </div>

                                <input type="hidden" name="key_subjects" id="keySubjectsHidden" required>
                                <small class="text-muted">Click on subjects to add them as tags</small>
                                <div class="error">Required</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Marksheet (Upload Marksheet)
                                    <span class="text-danger">*</span>
                                </label>
                                <input name="marksheet" id="marksheetInput" class="form-control" type="file"
                                    accept=".jpg,.jpeg,.png,.pdf" required />
                                <small class="text-muted">Allowed formats: JPG, JPEG, PNG, PDF (Max 1MB)</small>
                                <div class="error" id="marksheetError"></div>

                                <div class="file-preview" id="marksheetPreview">
                                    <img id="marksheetImage" src="" alt="Preview">
                                    <div class="marksheet-info" id="marksheetInfo"></div>
                                </div>


                            </div>



                            <div class="col-md-6">
                                <label class="form-label">Gap Year after Class 12?
                                    <span class="small text-muted">(optional)</span></label>
                                <select name="gap_year" id="gap_year" class="form-select">
                                    <option value="No">No</option>
                                    <option value="Yes">Yes</option>
                                </select>
                            </div>

                            <div class="col-md-6 gap_explain_col" style="display: none">
                                <label class="form-label">Gap Certificate (Upload Gap Certificate)
                                    <span class="text-danger">(optional)</span>
                                </label>
                                <input name="gap_certificate" id="gap_certificateInput" class="form-control" type="file"
                                    accept=".jpg,.jpeg,.png,.pdf" />
                                <small class="text-muted">Allowed formats: JPG, JPEG, PNG, PDF (Max 1MB)</small>
                                <div class="error" id="gap_certificateError"></div>

                                <div class="file-preview" id="gapPreview">
                                    <img id="gapImage" src="" alt="Preview">
                                    <div class="gap-info" id="gapInfo"></div>
                                </div>
                            </div>

                            <div class="col-12 gap_explain_col" style="display: none">
                                <label class="form-label">If Yes, brief explanation
                                    <span class="small text-muted">(optional)</span></label>
                                <textarea name="gap_explain" class="form-control" rows="3"></textarea>
                            </div>
                        </div>

                        <!-- UG Course Checkbox -->
                        <div class="col-12 mt-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="hasUG" name="has_ug">
                                <label class="form-check-label fw-bold" for="hasUG">
                                    Have you completed an Undergraduate (UG) course?
                                </label>
                            </div>
                        </div>

                        <!-- UG Details Form (Initially Hidden) -->
                        <div id="ugDetailsBox" class="py-3" style="display:none;">
                            <h6 class="mb-3">UG Course Details</h6>

                            <div class="row gy-2">
                                <div class="col-md-6">
                                    <label class="form-label">UG Course Name <span class="text-danger">*</span></label>
                                    <input type="text" name="ug_course" class="form-control">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Stream / Subject <span
                                            class="text-danger">*</span></label>
                                    <input type="text" name="ug_stream" class="form-control">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">College Name <span class="text-danger">*</span></label>
                                    <input type="text" name="ug_college" class="form-control">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">University Name <span class="text-danger">*</span></label>
                                    <input type="text" name="ug_university" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Passing Year <span class="text-danger">*</span></label>
                                    <input type="number" name="ug_passing_year" class="form-control" min="1900"
                                        max="2099">
                                </div>

                                <div class="col-md-4">
                                    <label class="form-label">Percentage / CGPA <span
                                            class="text-danger">*</span></label>
                                    <input type="text" name="ug_percentage" class="form-control">
                                </div>

                                <div class="col-md-4 gap_explain_col">
                                    <label class="form-label">Final Year Marksheet
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input name="ug_marksheet" id="ugmarksheetInput" class="form-control" type="file"
                                        accept=".jpg,.jpeg,.png,.pdf" />
                                    <small class="text-muted">Allowed formats: JPG, JPEG, PNG, PDF (Max 1MB)</small>
                                    <div class="error" id="ugmarksheetError"></div>

                                    <div class="file-preview" id="ugmarksheetPreview">
                                        <img id="ugmarksheetImage" src="" alt="Preview">
                                        <div class="ugmarksheet-info" id="ugmarksheetInfo"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- STEP 4: Program Preference -->
                    <div class="step" data-step="3" id="step-3">
                        <h5>4)Program Preference</h5>

                        <div id="prefContainer">

                            <div class="row align-items-center gy-2 mt-2 pref-row">
                                <div class="col-10">
                                    <label class="form-label">Preference <span class="text-danger">*</span></label>
                                    <select name="preference1[]" class="form-select pref-select" required>
                                        <option value="">Select Program</option>
                                        <?php foreach ($courses as $data): ?>
                                            <option value="<?= $data->course_name ?> (<?= $data->subjects ?>)">
                                                <?= $data->course_name ?> (<?= $data->subjects ?>)
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <div class="error">Required</div>
                                </div>

                                <div class="col-2 mt-5">
                                    <button type="button" class="btn btn-primary addPref">+</button>
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- STEP 5: Declarations & Consent -->
                    <div class="step" data-step="4" id="step-4">
                        <h5>5)Declarations & Consent</h5>

                        <div class="mt-2">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="agree_rules" id="agree_rules"
                                    required />
                                <label class="form-check-label" for="agree_rules">I have read and agree to the Admission
                                    Rules.
                                    <span class="text-danger">*</span></label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="consent_data" id="consent_data"
                                    required />
                                <label class="form-check-label" for="consent_data">I consent to the college processing
                                    my data for admissions,
                                    as per the Privacy Policy.
                                    <span class="text-danger">*</span></label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="declare_true" id="declare_true"
                                    required />
                                <label class="form-check-label" for="declare_true">I declare the information given is
                                    true to the best of my
                                    knowledge. <span class="text-danger">*</span></label>
                            </div>

                            <div class="row gy-2 mt-3">
                                <div class="col-md-6">
                                    <label class="form-label">E-Sign (Upload Signature)
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input name="esign" id="esignInput" class="form-control" type="file"
                                        accept=".jpg,.jpeg,.png" required />
                                    <small class="text-muted">Allowed formats: JPG, JPEG, PNG (Max 2MB)</small>
                                    <div class="error" id="fileError"></div>

                                    <div class="file-preview" id="filePreview">
                                        <img id="previewImg" src="" alt="Preview">
                                        <div class="file-info" id="fileInfo"></div>
                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <label class="form-label">Date <span class="text-danger">*</span></label>
                                    <input name="esign_date" id="esign_date" class="form-control" type="date"
                                        required />
                                    <div class="error">Required</div>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Passport Photo
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input name="passport_photo" id="passport_photo" class="form-control" type="file"
                                        accept=".jpg,.jpeg,.png" required />
                                    <small class="text-muted">Allowed formats: JPG, JPEG, PNG (Max 2MB)</small>
                                    <div class="error" id="imageError"></div>
                                    <div class="file-preview" id="imagePreview">
                                        <img id="previewImage" src="" alt="Preview">
                                        <div class="image-info" id="imageInfo"></div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- STEP 6: Review & Submit -->
                    <div class="step" data-step="5" id="step-5">
                        <h5>Review & Submit</h5>
                        <div class="mt-2 review p-3 bg-light rounded" id="review_area" aria-live="polite"></div>
                    </div>

                    <!-- Navigation -->
                    <div class="d-flex gap-2 mt-3 justify-content-between">
                        <button type="button" id="prevBtn" class="btn btn-secondary" style="display: none">
                            ← Previous
                        </button>
                        <div class="ms-auto d-flex gap-2">
                            <button type="button" id="saveDraft" class="btn btn-outline-secondary">
                                Save Draft
                            </button>
                            <button type="button" id="nextBtn" class="btn btn-primary">
                                Next →
                            </button>
                            <button type="submit" id="submitBtn" class="btn btn-success" style="display: none">
                                Submit
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php include_once('common_page/footer.php'); ?>
    <?php include_once('common_page/script.php'); ?>

    <script>
        (function () {
            const form = document.getElementById("regForm");
            const steps = Array.from(document.querySelectorAll(".step"));
            const pills = Array.from(document.querySelectorAll(".step-ind .pill"));
            const nextBtn = document.getElementById("nextBtn");
            const prevBtn = document.getElementById("prevBtn");
            const submitBtn = document.getElementById("submitBtn");
            const reviewArea = document.getElementById("review_area");
            const AUTOSAVE_KEY = "appDraft_v1";
            let current = 0;
            let autosaveTimer = null;
            const AUTOSAVE_INTERVAL_MS = 20000;

            // ===== GENERIC IMAGE PREVIEW FUNCTION =====
            function initImagePreview(options) {
                const { inputId, previewContainerId, previewImgId, infoId, errorId } = options;
                const input = document.getElementById(inputId);
                const previewContainer = document.getElementById(previewContainerId);
                const previewImg = document.getElementById(previewImgId);
                const info = document.getElementById(infoId);
                const errorEl = document.getElementById(errorId);
                const allowedExtensions = ['jpg', 'jpeg', 'png'];
                const maxFileSize = 2 * 1024 * 1024; // 2MB

                if (!input) return;

                input.addEventListener('change', function () {
                    const file = this.files[0];
                    if (errorEl) errorEl.style.display = 'none';
                    if (previewContainer) previewContainer.style.display = 'none';
                    if (!file) return;

                    const ext = file.name.split('.').pop().toLowerCase();
                    if (!allowedExtensions.includes(ext)) return showFileError('Only JPG/JPEG/PNG allowed');
                    if (file.size > maxFileSize) return showFileError('Max 2MB allowed');
                    const validMimes = ['image/jpeg', 'image/jpg', 'image/png'];
                    if (!validMimes.includes(file.type)) return showFileError('Invalid file type');

                    const reader = new FileReader();
                    reader.onload = function (e) {
                        if (previewImg) previewImg.src = e.target.result;
                        if (info) info.innerHTML = `<strong>File:</strong> ${file.name}<br>
                                        <strong>Size:</strong> ${(file.size / 1024 / 1024).toFixed(2)} MB`;
                        if (previewContainer) previewContainer.style.display = 'block';
                    };
                    reader.readAsDataURL(file);
                });

                function showFileError(msg) {
                    if (errorEl) {
                        errorEl.textContent = msg;
                        errorEl.style.display = 'block';
                    }
                    if (input) input.value = '';
                }
            }

            // ===== INIT IMAGE PREVIEWS =====
            initImagePreview({
                inputId: 'passport_photo',
                previewContainerId: 'imagePreview',
                previewImgId: 'previewImage',
                infoId: 'imageInfo',
                errorId: 'imageError'
            });

            initImagePreview({
                inputId: 'esignInput',
                previewContainerId: 'filePreview',
                previewImgId: 'previewImg',
                infoId: 'fileInfo',
                errorId: 'fileError'
            });

            initImagePreview({
                inputId: 'marksheetInput',
                previewContainerId: 'marksheetPreview',
                previewImgId: 'marksheetImage',
                infoId: 'marksheetInfo',
                errorId: 'marksheetError'
            });

            initImagePreview({
                inputId: 'gap_certificateInput',
                previewContainerId: 'gapPreview',
                previewImgId: 'gapImage',
                infoId: 'gapInfo',
                errorId: 'gap_certificateError'
            });

            initImagePreview({
                inputId: 'ugmarksheetInput',
                previewContainerId: 'ugmarksheetPreview',
                previewImgId: 'ugmarksheetImage',
                infoId: 'ugmarksheetInfo',
                errorId: 'ugmarksheetError'
            });


            // ===== RESULT STATUS & PERCENTAGE =====
            const resultStatusEl = document.getElementById('result_status');
            const percentageCol = document.getElementById('percentage_col');
            const percentageInput = document.querySelector('[name="percentage"]');
            if (resultStatusEl) {
                resultStatusEl.addEventListener('change', function () {
                    if (this.value === 'Declared') {
                        if (percentageCol) percentageCol.style.display = 'block';
                        if (percentageInput) percentageInput.setAttribute('required', 'required');
                    } else {
                        if (percentageCol) percentageCol.style.display = 'none';
                        if (percentageInput) { percentageInput.removeAttribute('required'); percentageInput.value = ''; }
                    }
                });
                if (resultStatusEl.value === 'Declared') { if (percentageCol) percentageCol.style.display = 'block'; if (percentageInput) percentageInput.setAttribute('required', 'required'); }
            }

            // ===== GAP YEAR =====
            const gapYearEl = document.getElementById('gap_year');
            const gapExplainCols = document.querySelectorAll('.gap_explain_col');

            if (gapYearEl) {
                gapYearEl.addEventListener('change', function () {
                    if (this.value === 'Yes') {
                        gapExplainCols.forEach(col => col.style.display = 'block');
                    } else {
                        gapExplainCols.forEach(col => col.style.display = 'none');
                    }
                });

                if (gapYearEl.value === 'Yes') {
                    gapExplainCols.forEach(col => col.style.display = 'block');
                }
            }

            // ===== UG COURSE TOGGLE =====
            const hasUGEl = document.getElementById('hasUG');
            const ugDetailsBox = document.getElementById('ugDetailsBox');
            if (hasUGEl && ugDetailsBox) {
                hasUGEl.addEventListener('change', function () {
                    ugDetailsBox.style.display = this.checked ? 'block' : 'none';
                    ugDetailsBox.querySelectorAll('input, select, textarea').forEach(inp => {
                        if (this.checked) inp.setAttribute('required', 'required');
                        else inp.removeAttribute('required');
                    });
                });
                if (hasUGEl.checked) {
                    ugDetailsBox.style.display = 'block';
                    ugDetailsBox.querySelectorAll('input, select, textarea').forEach(inp => inp.setAttribute('required', 'required'));
                }
            }

            // ===== TAG SYSTEM =====
            const SUBJECTS = {
                "Science": ["Physics", "Chemistry", "Biology", "Mathematics", "Computer Science", "Environmental Science", "Biotechnology"],
                "Commerce": ["Accountancy", "Business Studies", "Economics", "Entrepreneurship", "Banking", "Finance"],
                "Arts/Humanities": ["History", "Geography", "Political Science", "Psychology", "Sociology", "Philosophy", "English Literature", "Hindi Literature"],
                "Languages": ["English", "Hindi", "Sanskrit", "French", "German", "Spanish"],
                "Vocational": ["Information Technology", "Web Development", "Graphic Design", "Marketing", "Hotel Management", "Fashion Design"]
            };
            const allSubjects = Object.values(SUBJECTS).flat();
            const tagContainer = document.getElementById('tagContainer');
            const tagInput = document.getElementById('tagInput');
            const tagSuggestions = document.getElementById('tagSuggestions');
            // support both id variants: #keySubjectsHidden or input[name="key_subjects"]
            let hiddenInput = document.getElementById('keySubjectsHidden') || form.querySelector('[name="key_subjects"]');
            const selectedTags = new Set();

            function initTagSystem() {
                if (!tagContainer || !tagInput || !tagSuggestions || !hiddenInput) return;
                tagInput.addEventListener('focus', () => showAllSubjects());
                tagInput.addEventListener('input', () => {
                    const q = tagInput.value.trim().toLowerCase();
                    if (q === '') showAllSubjects(); else filterSubjects(q);
                });
                document.addEventListener('click', (e) => { if (!tagContainer.contains(e.target)) tagSuggestions.classList.remove('show'); });
            }

            function showAllSubjects() {
                let html = '';
                for (const [cat, subs] of Object.entries(SUBJECTS)) {
                    const avail = subs.filter(s => !selectedTags.has(s));
                    if (avail.length > 0) {
                        html += `<div class="suggestion-category">${cat}</div>`;
                        avail.forEach(s => html += `<div class="suggestion-item" data-subject="${s}">${s}</div>`);
                    }
                }
                tagSuggestions.innerHTML = html || '<div class="suggestion-item">No subjects</div>';
                tagSuggestions.classList.add('show');
                addSuggestionListeners();
            }

            function filterSubjects(query) {
                const filt = allSubjects.filter(s => s.toLowerCase().includes(query) && !selectedTags.has(s));
                tagSuggestions.innerHTML = filt.length ? filt.map(s => `<div class="suggestion-item" data-subject="${s}">${s}</div>`).join('') : '<div class="suggestion-item">No match</div>';
                tagSuggestions.classList.add('show');
                addSuggestionListeners();
            }

            function addSuggestionListeners() {
                document.querySelectorAll('.suggestion-item[data-subject]').forEach(item => {
                    item.addEventListener('click', () => addTag(item.dataset.subject));
                });
            }

            function addTag(sub) {
                if (selectedTags.has(sub)) return;
                selectedTags.add(sub);
                const tag = document.createElement('div');
                tag.className = 'tag';
                tag.innerHTML = `<span>${sub}</span><button type="button" class="tag-remove" data-subject="${sub}">&times;</button>`;
                const dropdown = tagContainer.querySelector('.tag-dropdown');
                if (dropdown) tagContainer.insertBefore(tag, dropdown); else tagContainer.appendChild(tag);
                tag.querySelector('.tag-remove').addEventListener('click', () => removeTag(sub));
                updateTagHiddenInput();
                tagInput.value = ''; tagInput.focus(); showAllSubjects();
            }

            function removeTag(sub) {
                selectedTags.delete(sub);
                tagContainer.querySelectorAll('.tag').forEach(t => { if (t.querySelector('.tag-remove').dataset.subject === sub) t.remove(); });
                updateTagHiddenInput();
                if (tagInput.value.trim() !== '') filterSubjects(tagInput.value.toLowerCase().trim());
            }

            function updateTagHiddenInput() { if (hiddenInput) hiddenInput.value = Array.from(selectedTags).join(','); }
            function loadTagsFromDraft(str) { if (!str) return; str.split(',').map(t => t.trim()).filter(Boolean).forEach(t => { if (allSubjects.includes(t)) addTag(t); }); }

            // Gather unique options for reuse (string from PHP)
            let allOptions = `
                <option value="">Select Program</option>
                <?php foreach ($courses as $data): ?>
                    <option value="<?= $data->course_name ?> (<?= $data->subjects ?>)">
                        <?= $data->course_name ?> (<?= $data->subjects ?>)
                    </option>
                <?php endforeach; ?>
            `;

            const prefContainer = document.getElementById('prefContainer');

            // ADD row
            $(document).on("click", ".addPref", function () {
                addPrefRow('');
            });

            function addPrefRow(selectedValue = '') {
                const html = `
                <div class="row align-items-center gy-2 mt-2 pref-row">
                    <div class="col-10">
                        <select name="preference1[]" class="form-select pref-select" required>
                            ${allOptions}
                        </select>
                        <div class="error">Required</div>
                    </div>
                    <div class="col-2 mt-4">
                        <button type="button" class="btn btn-danger removePref">-</button>
                    </div>
                </div>`;
                $(prefContainer).append(html);
                // set the value for the last added
                const last = $(prefContainer).find('.pref-select').last();
                if (selectedValue) last.val(selectedValue);
                updateDropdowns();
            }

            // REMOVE row
            $(document).on("click", ".removePref", function () {
                $(this).closest(".pref-row").remove();
                updateDropdowns();
            });

            // Update selected values so they don't appear in other dropdowns
            $(document).on("change", ".pref-select", function () {
                updateDropdowns();
            });

            function updateDropdowns() {
                const selected = [];
                // gather selected values (array)
                $(".pref-select").each(function () {
                    const val = $(this).val();
                    if (val !== "") selected.push(val);
                });

                $(".pref-select").each(function () {
                    const currentVal = $(this).val();
                    $(this).find("option").show(); // reset all options

                    // Hide already selected except current itself
                    selected.forEach(sel => {
                        if (sel !== currentVal) {
                            $(this).find("option[value='" + sel.replace(/'/g, "\\'") + "']").hide();
                        }
                    });
                });
            }

            // ===== STEP NAVIGATION =====
            function showStep(idx) {
                if (idx < 0 || idx >= steps.length) return;
                steps.forEach((s) => { s.classList.remove('active'); s.style.display = 'none'; });
                const step = steps[idx]; step.style.display = ''; step.classList.add('active'); current = idx;
                updatePills();
                const first = step.querySelector('input, select, textarea'); if (first) first.focus();
                if (current === steps.length - 1) populateReviewTable();
            }

            function updatePills() {
                pills.forEach((p, i) => {
                    p.classList.toggle('active', i === current);
                    if (i < current) p.classList.add('completed'); else p.classList.remove('completed');
                });
                prevBtn.style.display = current === 0 ? 'none' : '';
                nextBtn.style.display = current === steps.length - 1 ? 'none' : '';
                submitBtn.style.display = current === steps.length - 1 ? '' : 'none';
            }

            function validateStep(idx) {
                const step = steps[idx]; let valid = true;
                step.querySelectorAll(".error").forEach(e => e.style.display = 'none');
                const req = Array.from(step.querySelectorAll("[required]"));
                for (const el of req) {
                    const val = (el.value || "").trim();
                    if (val === '') { showInlineError(el, "Required"); valid = false; continue; }
                    if (el.name === 'mobile' && !/^[6-9]\d{9}$/.test(val.replace(/\D/g, ''))) { showInlineError(el, "Invalid mobile"); valid = false; }
                    if ((el.name === 'pin' || el.name === 'pincode') && !/^\d{6}$/.test(val.replace(/\D/g, ''))) { showInlineError(el, "Invalid PIN"); valid = false; }
                    if (el.name === 'percentage' && !/^\d+(\.\d+)?$/.test(val)) { showInlineError(el, "Invalid number"); valid = false; }
                    if (el.type === 'email' && !/^\S+@\S+\.\S+$/.test(val)) { showInlineError(el, "Invalid email"); valid = false; }
                }
                return valid;
            }

            function showInlineError(el, msg) {
                const err = el.closest(".col-md-6")?.querySelector(".error") || el.closest(".col-12")?.querySelector(".error") || el.parentElement?.querySelector(".error");
                if (err) { err.style.display = 'block'; err.textContent = msg; }
            }

            nextBtn.addEventListener('click', () => { if (validateStep(current)) { saveDraft(); if (current < steps.length - 1) showStep(current + 1); } });
            prevBtn.addEventListener('click', () => { if (current > 0) showStep(current - 1); });

            pills.forEach((p, i) => p.addEventListener('click', () => {
                if (i < current) { showStep(i); return; }
                for (let j = 0; j < i; j++) { if (!validateStep(j)) return; }
                showStep(i);
            }));

            // ===== REVIEW TABLE =====
            function populateReviewTable() {
                const data = new FormData(form);

                // handle preference1 (multiple)
                const prefs = data.getAll("preference1[]");
                const prefHtml = prefs.length ? prefs.join(', ') : (data.get("preference1") || "");

                // ---- MULTIPLE IMAGE HANDLING ----
                function makeImagePreview(fileList) {
                    if (!fileList || fileList.length === 0) return "No file";

                    let html = "<div style='display:flex;gap:10px;flex-wrap:wrap'>";
                    for (let f of fileList) {
                        const url = URL.createObjectURL(f);
                        html += `<img src="${url}" style="width:70px;height:70px;object-fit:cover;border:1px solid #ddd;border-radius:4px;">`;
                    }
                    html += "</div>";
                    return html;
                }

                const passportFiles = form.querySelector("#passport_photo")?.files;
                const esignFiles = form.querySelector("#esignInput")?.files;
                const marksheetFiles = form.querySelector("#marksheetInput")?.files;
                const gapFiles = form.querySelector("#gap_certificateInput")?.files;
                const ugMarksheetFiles = form.querySelector("#ugmarksheetInput")?.files;

                const rows = [
                    ["Full Name", data.get("full_name") || ""],
                    ["DOB", data.get("dob") || ""],
                    ["Mobile", data.get("mobile") || ""],
                    ["Email", data.get("email") || ""],
                    ["Parent Name", data.get("parent_name") || ""],
                    ["Parent Mobile", data.get("parent_mobile") || ""],
                    ["Gender", data.get("gender") || ""],
                    ["Govt ID Type", data.get("govt_id_type") || ""],
                    ["Govt ID Number", data.get("govt_id_number") || ""],
                    ["Address Line1", data.get("addr1") || ""],
                    ["Address Line2", data.get("addr2") || ""],
                    ["City", data.get("city") || ""],
                    ["State/UT", data.get("state_ut") || ""],
                    ["PIN", data.get("pin") || ""],
                    ["Domicile", data.get("domicile") || ""],
                    ["Board", data.get("board") || ""],
                    ["Stream", data.get("stream") || ""],
                    ["School Name", data.get("school_name") || ""],
                    ["School City", data.get("school_city") || ""],
                    ["Passing Year", data.get("passing_year") || ""],
                    ["Result Status", data.get("result_status") || ""],
                    ["Percentage/Grade", data.get("percentage") || ""],
                    ["Key Subjects", data.get("key_subjects") || ""],
                    ["Gap Year", data.get("gap_year") || ""],
                    ["Gap Explanation", data.get("gap_explain") || ""],
                    ["UG Course", form.querySelector('[name="has_ug"]')?.checked ? "Yes" : "No"],
                    ["UG Course Name", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_course") || "" : "N/A"],
                    ["UG Stream", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_stream") || "" : "N/A"],
                    ["UG College", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_college") || "" : "N/A"],
                    ["UG University", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_university") || "" : "N/A"],
                    ["UG Passing Year", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_passing_year") || "" : "N/A"],
                    ["UG Percentage", form.querySelector('[name="has_ug"]')?.checked ? data.get("ug_percentage") || "" : "N/A"],
                    ["Preference", prefHtml],
                    ["Agreed Rules", data.get("agree_rules") ? "Yes" : "No"],
                    ["Consent Data", data.get("consent_data") ? "Yes" : "No"],
                    ["Declare True", data.get("declare_true") ? "Yes" : "No"],

                    // ==== IMAGE PREVIEW ROWS ====
                    ["Passport Photo", makeImagePreview(passportFiles)],
                    ["E-Sign", makeImagePreview(esignFiles)],
                    ["Marksheet", makeImagePreview(marksheetFiles)],
                    ["Gap Certificate", makeImagePreview(gapFiles)],
                    ["UG Marksheet", makeImagePreview(ugMarksheetFiles)],
                ];

                let html = '<div class="table-responsive"><table class="table table-sm table-bordered"><tbody>';
                rows.forEach(r => {
                    html += `<tr><th style="width:40%">${r[0]}</th><td>${r[1]}</td></tr>`;
                });
                html += '</tbody></table></div>';

                reviewArea.innerHTML = html;
            }


            // ===== AUTOSAVE =====
            function saveDraft(finalSave = false) {
                try {
                    updateTagHiddenInput();
                    // we will gather values in a safer way to include checkboxes / multi selects / arrays
                    const dataObj = {};
                    const fm = new FormData(form);
                    for (const [k, v] of fm.entries()) {
                        // handle array keys 'preference1[]' - normalize to 'preference1'
                        const key = k.endsWith('[]') ? k.replace(/\[\]$/, '') : k;
                        if (dataObj.hasOwnProperty(key)) {
                            if (!Array.isArray(dataObj[key])) dataObj[key] = [dataObj[key]];
                            dataObj[key].push(v);
                        } else {
                            dataObj[key] = v;
                        }
                    }
                    dataObj._savedAt = new Date().toISOString();
                    if (finalSave) dataObj._finalSaved = "1";
                    // Note: file inputs cannot be reliably stored in localStorage; we skip actual file data
                    localStorage.setItem(AUTOSAVE_KEY, JSON.stringify(dataObj));
                } catch (e) {
                    console.warn("Draft save failed", e);
                }
            }

            function loadDraft() {
                try {
                    const raw = localStorage.getItem(AUTOSAVE_KEY);
                    if (!raw) return;
                    const obj = JSON.parse(raw);

                    // Fill simple inputs / selects / textareas / radios / checkboxes / multi-values
                    for (const k in obj) {
                        if (!obj.hasOwnProperty(k)) continue;
                        if (k.startsWith('_')) continue; // meta fields
                        const value = obj[k];

                        // preference1 (array) handled separately
                        if (k === 'preference1') continue;
                        // Tag hidden handled separately
                        if (k === 'key_subjects' || k === 'keySubjectsHidden') {
                            loadTagsFromDraft(value);
                            continue;
                        }

                        // try to find elements with this name
                        const els = form.querySelectorAll('[name="' + k + '"]');
                        if (!els || els.length === 0) continue;

                        // multiple elements (checkboxes / radios)
                        if (els.length > 1) {
                            els.forEach(el => {
                                if (el.type === 'checkbox') {
                                    // value might be "on" or actual value
                                    if (Array.isArray(value)) {
                                        el.checked = value.includes(el.value) || value.includes('on') || value.includes('1');
                                    } else {
                                        el.checked = (value === el.value) || (value === 'on') || (value === '1');
                                    }
                                } else if (el.type === 'radio') {
                                    el.checked = (value === el.value);
                                } else {
                                    // multiple selects? set individually
                                    el.value = value;
                                }
                            });
                            continue;
                        }

                        // single element
                        const el = els[0];
                        if (!el) continue;
                        if (el.type === 'checkbox') {
                            el.checked = (value === 'on' || value === '1' || value === true);
                        } else if (el.type === 'radio') {
                            el.checked = (el.value === value);
                        } else if (el.tagName.toLowerCase() === 'select' && el.multiple && Array.isArray(value)) {
                            // set multiple select
                            Array.from(el.options).forEach(opt => opt.selected = value.includes(opt.value));
                        } else {
                            // normal input/select/textarea
                            el.value = value;
                        }
                    }

                    // Restore preference1[] rows (array or single)
                    if (obj.preference1) {
                        // normalize to array
                        const prefs = Array.isArray(obj.preference1) ? obj.preference1 : [obj.preference1];
                        // clear existing rows
                        $(prefContainer).find('.pref-row').remove();
                        // add rows for each preference
                        prefs.forEach(pv => addPrefRow(pv));
                        // ensure at least one row exists
                        if ($(prefContainer).find('.pref-row').length === 0) addPrefRow('');
                    } else {
                        // if none saved, ensure at least one exists (keep existing markup if any)
                        if (!$(prefContainer).find('.pref-row').length) addPrefRow('');
                    }

                    // If has_ug present and truthy
                    const hasUGVal = obj.has_ug || obj.hasUG || obj['has_ug'];
                    if (typeof hasUGVal !== 'undefined') {
                        if (hasUGEl) {
                            const truthy = (hasUGVal === 'on' || hasUGVal === '1' || hasUGVal === true || hasUGVal === 'true');
                            hasUGEl.checked = truthy;
                            ugDetailsBox.style.display = truthy ? 'block' : 'none';
                            ugDetailsBox.querySelectorAll('input, select, textarea').forEach(inp => {
                                if (truthy) inp.setAttribute('required', 'required'); else inp.removeAttribute('required');
                            });
                        }
                    }

                    // load tags (if key_subjects exists)
                    if (obj.key_subjects) loadTagsFromDraft(obj.key_subjects);
                    // also support keySubjectsHidden name/id
                    if (obj.keySubjectsHidden && !obj.key_subjects) loadTagsFromDraft(obj.keySubjectsHidden);

                    // After filling, update dropdown hides
                    updateDropdowns();

                    // If file meta was saved (we don't save actual file), show filename if present
                    if (obj.esign && typeof obj.esign === 'string' && fileInfo) {
                        fileInfo.innerHTML = `<strong>File:</strong> ${obj.esign}`;
                        if (filePreview) filePreview.style.display = 'block';
                    }
                } catch (e) {
                    console.warn("Draft load failed", e);
                }
            }

            function startAutosave() { autosaveTimer = setInterval(() => saveDraft(false), AUTOSAVE_INTERVAL_MS); }

            // INIT
            initTagSystem();
            // ensure at least one pref row exists on load in case HTML didn't contain one
            if (!document.querySelector('#prefContainer .pref-row')) addPrefRow('');
            showStep(0);
            loadDraft();
            startAutosave();

            // expose saveDraft for final submit if needed
            window.saveDraft = saveDraft;
        })();
    </script>






</body>

</html>