<?php
defined('BASEPATH') OR exit('No direct script access allowed');
if ( ! function_exists('directory_map'))
{
	
	function directory_map($source_dir, $directory_depth = 0, $hidden = FALSE)
	{
		if ($fp = @opendir($source_dir))
		{
			$filedata	= array();
			$new_depth	= $directory_depth - 1;
			$source_dir	= rtrim($source_dir, DIRECTORY_SEPARATOR).DIRECTORY_SEPARATOR;
			while (FALSE !== ($file = readdir($fp)))
			{
				
				if ($file === '.' OR $file === '..' OR ($hidden === FALSE && $file[0] === '.'))
				{
					continue;
				}
				is_dir($source_dir.$file) && $file .= DIRECTORY_SEPARATOR;
				if (($directory_depth < 1 OR $new_depth > 0) && is_dir($source_dir.$file))
				{
					$filedata[$file] = directory_map($source_dir.$file, $new_depth, $hidden);
				}
				else
				{
					$filedata[] = $file;
				}
			}
			closedir($fp);
			return $filedata;
		}
		return FALSE;
	}
}